/*
 * Decompiled with CFR 0.152.
 */
package routines;

public class StringHandling {
    public static boolean ALPHA(String input) {
        if (input != null) {
            char[] val = input.toCharArray();
            int i = 0;
            while (i < val.length - 1) {
                if (val[i] > val[i + 1]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean IS_ALPHA(String input) {
        if (input != null) {
            char[] val = input.toCharArray();
            int i = 0;
            while (i < val.length - 1) {
                if (!Character.isLetter(val[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String CHANGE(String oldStr, String newStr, String replacement) {
        if (oldStr == null || newStr == null || replacement == null) {
            return oldStr;
        }
        return oldStr.replaceAll(newStr, replacement);
    }

    public static int COUNT(String string, String subString) {
        if (string == null || subString == null) {
            return 0;
        }
        int counter = 0;
        int i = -1;
        while ((i = string.indexOf(subString, i + 1)) != -1) {
            ++counter;
        }
        return counter;
    }

    public static String DOWNCASE(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String UPCASE(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static String DQUOTE(String string) {
        return string == null ? null : "\"" + string + "\"";
    }

    public static String EREPLACE(String oldStr, String newStr, String replacement) {
        if (oldStr == null || newStr == null || replacement == null) {
            return oldStr;
        }
        return oldStr.replaceAll(newStr, replacement);
    }

    public static int INDEX(String string, String element) {
        if (string == null || element == null) {
            return -1;
        }
        return string.indexOf(element);
    }

    public static String LEFT(String string, int index) {
        return string == null ? null : string.substring(0, Math.min(string.length(), index));
    }

    public static String RIGHT(String string, int index) {
        return string == null ? null : string.substring(string.length() - Math.min(string.length(), index));
    }

    public static int LEN(String string) {
        return string == null ? -1 : string.length();
    }

    public static String SPACE(int i) {
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            buffer.append(" ");
            ++j;
        }
        return buffer.toString();
    }

    public static String SQUOTE(String string) {
        return string == null ? null : "'" + string + "'";
    }

    public static String STR(char letter, int i) {
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            buffer.append(letter);
            ++j;
        }
        return buffer.toString();
    }

    public static String TRIM(String string) {
        return string == null ? null : string.trim();
    }

    public static String BTRIM(String string) {
        if (string == null) {
            return null;
        }
        char[] val = string.toCharArray();
        int len = val.length;
        while (len > 0 && val[len - 1] <= ' ') {
            --len;
        }
        return string.substring(0, len);
    }

    public static String FTRIM(String string) {
        if (string == null) {
            return null;
        }
        char[] val = string.toCharArray();
        int st = 0;
        int len = val.length;
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        return string.substring(st);
    }
}

