/*
 * Decompiled with CFR 0.152.
 */
package routines;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import routines.system.FastDateParser;
import routines.system.LocaleProvider;

public class TalendDate {
    public static synchronized String formatDate(String pattern, Date date) {
        return FastDateParser.getInstance(pattern).format(date);
    }

    public static boolean isDate(String stringDate, String pattern) {
        if (stringDate == null) {
            return false;
        }
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date testDate = null;
        try {
            testDate = sdf.parse(stringDate);
        }
        catch (ParseException e) {
            return false;
        }
        return sdf.format(testDate).equalsIgnoreCase(stringDate);
    }

    public static int compareDate(Date date1, Date date2, String pattern) {
        long time2;
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 != null && date2 == null) {
            return 1;
        }
        if (date1 == null && date2 != null) {
            return -1;
        }
        if (pattern != null) {
            String part2;
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            String part1 = sdf.format(date1);
            return part1.compareTo(part2 = sdf.format(date2)) >= 1 ? 1 : (part1.compareTo(part2) <= -1 ? -1 : 0);
        }
        long time1 = date1.getTime();
        return time1 < (time2 = date2.getTime()) ? -1 : (time1 == time2 ? 0 : 1);
    }

    public static int compareDate(Date date1, Date date2) {
        return TalendDate.compareDate(date1, date2, null);
    }

    public static Date addDate(Date date, int nb, String dateType) {
        if (date == null || dateType == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        if (dateType.equalsIgnoreCase("yyyy")) {
            c1.add(1, nb);
        } else if (dateType.equals("MM")) {
            c1.add(2, nb);
        } else if (dateType.equalsIgnoreCase("dd")) {
            c1.add(5, nb);
        } else if (dateType.equals("HH")) {
            c1.add(10, nb);
        } else if (dateType.equals("mm")) {
            c1.add(12, nb);
        } else if (dateType.equalsIgnoreCase("ss")) {
            c1.add(13, nb);
        } else if (dateType.equalsIgnoreCase("SSS")) {
            c1.add(14, nb);
        } else {
            throw new RuntimeException("Can't support the dateType: " + dateType);
        }
        return c1.getTime();
    }

    public static String addDate(String string, String pattern, int nb, String dateType) {
        if (string == null || dateType == null) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            date = sdf.parse(string);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.valueOf(pattern) + " can't support the date!");
        }
        String dateString = sdf.format(TalendDate.addDate(date, nb, dateType));
        return dateString;
    }

    public static long diffDate(Date date1, Date date2, String dateType) {
        if (date1 == null) {
            date1 = new Date(0L);
        }
        if (date2 == null) {
            date2 = new Date(0L);
        }
        if (dateType == null) {
            dateType = "SSS";
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        if (dateType.equalsIgnoreCase("yyyy")) {
            return c1.get(1) - c2.get(1);
        }
        if (dateType.equals("MM")) {
            return (c1.get(1) - c2.get(1)) * 12 + (c1.get(2) - c2.get(2));
        }
        if (dateType.equalsIgnoreCase("HH")) {
            return (date1.getTime() - date2.getTime()) / 3600000L;
        }
        if (dateType.equals("mm")) {
            return (date1.getTime() - date2.getTime()) / 60000L;
        }
        if (dateType.equalsIgnoreCase("ss")) {
            return (date1.getTime() - date2.getTime()) / 1000L;
        }
        if (dateType.equalsIgnoreCase("SSS")) {
            return date1.getTime() - date2.getTime();
        }
        if (dateType.equalsIgnoreCase("dd")) {
            return (date1.getTime() - date2.getTime()) / 86400000L;
        }
        throw new RuntimeException("Can't support the dateType: " + dateType);
    }

    public static long diffDate(Date date1, Date date2) {
        return TalendDate.diffDate(date1, date2, "dd");
    }

    public static Date getFirstDayOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int lastDay = c.getActualMaximum(5);
        c.set(5, lastDay);
        return c.getTime();
    }

    public static Date setDate(Date date, int nb, String dateType) {
        if (date == null || dateType == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (dateType.equalsIgnoreCase("yyyy")) {
            c.set(1, nb);
        } else if (dateType.equals("MM")) {
            c.set(2, nb - 1);
        } else if (dateType.equalsIgnoreCase("dd")) {
            c.set(5, nb);
        } else if (dateType.equalsIgnoreCase("HH")) {
            c.set(11, nb);
        } else {
            throw new RuntimeException("Can't support the dateType: " + dateType);
        }
        return c.getTime();
    }

    public static synchronized String formatDateLocale(String pattern, Date date, String languageOrCountyCode) {
        return FastDateParser.getInstance(pattern, LocaleProvider.getLocale(languageOrCountyCode)).format(date);
    }

    public static synchronized Date parseDate(String pattern, String stringDate) {
        try {
            return FastDateParser.getInstance(pattern).parse(stringDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized Date parseDateLocale(String pattern, String stringDate, String languageOrCountyCode) {
        try {
            return FastDateParser.getInstance(pattern, LocaleProvider.getLocale(languageOrCountyCode)).parse(stringDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDate(String pattern) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        StringBuffer result = new StringBuffer();
        pattern = pattern.replace("CC", "yy");
        pattern = pattern.replace("YY", "yy");
        pattern = pattern.replace("MM", "MM");
        pattern = pattern.replace("DD", "dd");
        pattern = pattern.replace("hh", "HH");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.format(Calendar.getInstance().getTime(), result, new FieldPosition(0));
        return result.toString();
    }

    public static Date getCurrentDate() {
        return Calendar.getInstance().getTime();
    }

    public static Date getRandomDate(String minDate, String maxDate) {
        if (minDate == null) {
            minDate = "1970-01-01";
        }
        if (maxDate == null) {
            maxDate = "2099-12-31";
        }
        if (!minDate.matches("\\d{4}-\\d{2}-\\d{2}") || !minDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new IllegalArgumentException("The parameter should be \"yyy-MM-dd\"");
        }
        int minYear = Integer.parseInt(minDate.substring(0, 4));
        int minMonth = Integer.parseInt(minDate.substring(5, 7));
        int minDay = Integer.parseInt(minDate.substring(8, 10));
        int maxYear = Integer.parseInt(maxDate.substring(0, 4));
        int maxMonth = Integer.parseInt(maxDate.substring(5, 7));
        int maxDay = Integer.parseInt(maxDate.substring(8, 10));
        Calendar minCal = Calendar.getInstance();
        minCal.set(1, minYear);
        minCal.set(2, minMonth - 1);
        minCal.set(5, minDay);
        Calendar maxCal = Calendar.getInstance();
        maxCal.set(1, maxYear);
        maxCal.set(2, maxMonth - 1);
        maxCal.set(5, maxDay);
        long random = minCal.getTimeInMillis() + (long)((double)(maxCal.getTimeInMillis() - minCal.getTimeInMillis() + 1L) * Math.random());
        return new Date(random);
    }

    public static void main(String[] args) {
        TalendDate.test_formatDate();
        TalendDate.test_isDate();
        TalendDate.test_getRandomDate();
    }

    public static void test_getRandomDate() {
        System.out.println("getRandomDate: " + TalendDate.formatDate("yyyy-MM-dd HH:mm:ss", TalendDate.getRandomDate(null, null)));
    }

    public static void test_compareDate() {
        System.out.println("compareDate: " + Boolean.toString(TalendDate.compareDate(new Date(), new Date(System.currentTimeMillis() - 10000L)) == 1));
    }

    public static void test_isDate() {
        System.out.println("isDate: " + Boolean.toString(!TalendDate.isDate("2008-11-35 12:15:25", "yyyy-MM-dd HH:mm")));
    }

    public static void test_formatDate() {
        int LOOPS = 100000;
        String dateTimeRef_Test1 = "1979-03-23 mars 12:30";
        Thread test1 = new Thread(){

            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1979, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDate("yyyy-MM-dd MMM HH:mm", dateCalendar);
                    if (!"1979-03-23 mars 12:30".equals(date)) {
                        throw new IllegalStateException("Test1: Date ref : '1979-03-23 mars 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test1 ok");
            }
        };
        String dateTimeRef_Test2 = "1980-03-23 mars 12:30";
        Thread test2 = new Thread(){

            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1980, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDate("yyyy-MM-dd MMM HH:mm", dateCalendar);
                    if (!"1980-03-23 mars 12:30".equals(date)) {
                        throw new IllegalStateException("Test2: Date ref : '1980-03-23 mars 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test2 ok");
            }
        };
        String dateTimeRef_Test3 = "1979-03-23 mars 12:30";
        Thread test3 = new Thread(){

            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1979, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDateLocale("yyyy-MM-dd MMM HH:mm", dateCalendar, "FR");
                    if (!"1979-03-23 mars 12:30".equals(date)) {
                        throw new IllegalStateException("Test3: Date ref : '1979-03-23 mars 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test3 ok");
            }
        };
        String dateTimeRef_Test4 = "1980-03-23 Mar 12:30";
        Thread test4 = new Thread(){

            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1980, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDateLocale("yyyy-MM-dd MMM HH:mm", dateCalendar, "EN");
                    if (!"1980-03-23 Mar 12:30".equals(date)) {
                        throw new IllegalStateException("Test4: Date ref : '1980-03-23 Mar 12:30' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test4 ok");
            }
        };
        String dateTimeRef_Test5 = "1979-03-23";
        Thread test5 = new Thread(){

            public void run() {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.set(1979, 2, 23, 12, 30, 40);
                Date dateCalendar = calendar.getTime();
                int i = 0;
                while (i < 100000) {
                    String date = TalendDate.formatDate("yyyy-MM-dd", dateCalendar);
                    if (!"1979-03-23".equals(date)) {
                        throw new IllegalStateException("Test5: Date ref : '1979-03-23' is different of '" + date + "'");
                    }
                    ++i;
                }
                System.out.println("test5 ok");
            }
        };
        test1.start();
        test2.start();
        test3.start();
        test4.start();
        test5.start();
    }
}

