/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetterCatcherUtils {
    ThreadLocal tl_messages = new ThreadLocal();
    String jobId = "";
    String jobVersion = "";
    private Map<String, Integer> connCountMap = Collections.synchronizedMap(new HashMap());

    private List<MetterCatcherMessage> getTLMessages() {
        Object value = this.tl_messages.get();
        if (value == null) {
            List<MetterCatcherMessage> messages = Collections.synchronizedList(new ArrayList());
            this.tl_messages.set(messages);
            return messages;
        }
        return (List)value;
    }

    public MetterCatcherUtils(String jobId, String jobVersion) {
        this.jobId = jobId;
        this.jobVersion = jobVersion;
    }

    public void addMessage(String label, Integer count, String referense, String thresholds, String origin) {
        List<MetterCatcherMessage> messages = this.getTLMessages();
        MetterCatcherMessage scm = new MetterCatcherMessage(label, count, referense, thresholds, origin, this.jobVersion, this.jobId);
        messages.add(scm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetterCatcherMessage> getMessages() {
        List<MetterCatcherMessage> messages = this.getTLMessages();
        ArrayList<MetterCatcherMessage> messagesToSend = new ArrayList<MetterCatcherMessage>();
        List<MetterCatcherMessage> list = messages;
        synchronized (list) {
            for (MetterCatcherMessage scm : messages) {
                messagesToSend.add(scm);
            }
        }
        messages.clear();
        return messagesToSend;
    }

    public void clearConnCountMap() {
        this.connCountMap.clear();
    }

    public void addLineToRow(String connName) {
        if (this.connCountMap.containsKey(connName)) {
            Integer count = this.connCountMap.get(connName);
            this.connCountMap.put(connName, new Integer(count + 1));
        } else {
            this.connCountMap.put(connName, new Integer(1));
        }
    }

    public Integer getConnLinesCount(String connName) {
        return this.connCountMap.get(connName);
    }

    public static long getPid() {
        RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
        String[] mxNameTable = mx.getName().split("@");
        if (mxNameTable.length == 2) {
            return Long.parseLong(mxNameTable[0]);
        }
        return Thread.currentThread().getId();
    }

    public class MetterCatcherMessage {
        private String origin;
        private Date moment = Calendar.getInstance().getTime();
        private String jobVersion;
        private String jobId;
        private Long systemPid;
        private String label;
        private Integer count;
        private String referense;
        private String thresholds;

        public MetterCatcherMessage(String label, Integer count, String referense, String thresholds, String origin, String jobVersion, String jobId) {
            this.jobVersion = jobVersion;
            this.jobId = jobId;
            this.systemPid = MetterCatcherUtils.getPid();
            this.origin = origin;
            this.label = label;
            this.count = count;
            this.referense = referense;
            this.thresholds = thresholds;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getReferense() {
            return this.referense;
        }

        public void setReferense(String referense) {
            this.referense = referense;
        }

        public String getThresholds() {
            return this.thresholds;
        }

        public void setThresholds(String thresholds) {
            this.thresholds = thresholds;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public Date getMoment() {
            return this.moment;
        }

        public void setMoment(Date d) {
            this.moment = d;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getJobVersion() {
            return this.jobVersion;
        }

        public void setJobVersion(String jobVersion) {
            this.jobVersion = jobVersion;
        }

        public Long getSystemPid() {
            return this.systemPid;
        }

        public void setSystemPid(Long systemPid) {
            this.systemPid = systemPid;
        }
    }
}

