/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RunTrace
implements Runnable {
    private boolean openSocket = true;
    private ConcurrentHashMap<String, TraceBean> processTraces = new ConcurrentHashMap();
    private Map<String, String> subjobMap = new HashMap<String, String>();
    private Socket s;
    private PrintWriter pred;
    private boolean jobIsFinished = false;
    private String str = "";
    private Thread t;
    private String componentName = "";

    public void openSocket(boolean openSocket) {
        this.openSocket = openSocket;
    }

    public void startThreadTrace(String clientHost, int portTraces) throws IOException, UnknownHostException {
        if (!this.openSocket) {
            return;
        }
        System.out.println("[trace] connecting to socket on port " + portTraces);
        this.s = new Socket(clientHost, portTraces);
        this.pred = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.s.getOutputStream())), true);
        System.out.println("[trace] connected");
        this.t = new Thread(this);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RunTrace runTrace = this;
        synchronized (runTrace) {
            try {
                while (!this.jobIsFinished) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException e) {
                System.out.println("[trace] interrupted");
            }
        }
    }

    public void stopThreadTrace() {
        if (!this.openSocket) {
            return;
        }
        this.jobIsFinished = true;
        try {
            this.pred.close();
            this.s.close();
            System.out.println("[trace] disconnected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isNextRow() {
        if (!this.openSocket) {
            return false;
        }
        try {
            this.askForStatus();
            InputStream in = this.s.getInputStream();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
            return "NEXT_ROW".equals(reader.readLine());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNextBreakpoint() {
        if (!this.openSocket) {
            return false;
        }
        try {
            this.askForStatus();
            InputStream in = this.s.getInputStream();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
            return "NEXT_BREAKPOINT".equals(reader.readLine());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void waitForUserAction() throws InterruptedException {
        if (!this.openSocket) {
            return;
        }
        try {
            boolean action = false;
            this.pred.println("UI_STATUS");
            do {
                InputStream in;
                LineNumberReader reader;
                String line;
                if ("STATUS_WAITING".equals(line = (reader = new LineNumberReader(new InputStreamReader(in = this.s.getInputStream()))).readLine())) {
                    this.pred.println("UI_STATUS");
                    Thread.sleep(100L);
                    continue;
                }
                action = true;
            } while (!action);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isPause() {
        if (!this.openSocket) {
            return false;
        }
        try {
            this.askForStatus();
            InputStream in = this.s.getInputStream();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
            return "PAUSE".equals(reader.readLine());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void askForStatus() {
        this.pred.println("ID_STATUS");
    }

    public void sendTrace(String componentId, String startNodeCid, String datas) {
        if (!this.openSocket) {
            return;
        }
        this.subjobMap.put(componentId, startNodeCid);
        Iterator<Map.Entry<String, String>> ite = this.subjobMap.entrySet().iterator();
        boolean sameSub = false;
        while (ite.hasNext()) {
            Map.Entry<String, String> en = ite.next();
            if (en.getKey().equals(componentId) || !en.getValue().equals(startNodeCid)) continue;
            sameSub = true;
            break;
        }
        if (sameSub && this.processTraces.size() > 1 && componentId.equals(this.componentName)) {
            return;
        }
        TraceBean bean = this.processTraces.containsKey(componentId) ? this.processTraces.get(componentId) : new TraceBean(componentId);
        bean.setNbLine(bean.getNbLine() + 1);
        this.processTraces.put(componentId, bean);
        this.str = String.valueOf(bean.getComponentId()) + "|" + bean.getNbLine() + "|" + datas;
        this.pred.println(this.str);
        this.componentName = componentId;
    }

    private class TraceBean {
        private String componentId;
        private int nbLine;

        public TraceBean(String componentId) {
            this.componentId = componentId;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        public int getNbLine() {
            return this.nbLine;
        }

        public void setNbLine(int nbLine) {
            this.nbLine = nbLine;
        }
    }
}

