/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SharedDBConnection {
    private static boolean DEBUG = false;
    private static SharedDBConnection instance = null;
    private Map<String, Connection> sharedConnections = new HashMap<String, Connection>();

    private SharedDBConnection() {
    }

    private static synchronized SharedDBConnection getInstance() {
        if (instance == null) {
            instance = new SharedDBConnection();
        }
        return instance;
    }

    private synchronized Connection getConnection(String dbDriver, String url, String userName, String password, String dbConnectionName) throws ClassNotFoundException, SQLException {
        Connection connection;
        if (DEBUG) {
            Set<String> keySet = this.sharedConnections.keySet();
            System.out.print("SharedDBConnection, current shared connections list is:");
            for (String key : keySet) {
                System.out.print(" " + key);
            }
            System.out.println();
        }
        if ((connection = this.sharedConnections.get(dbConnectionName)) == null) {
            if (DEBUG) {
                System.out.println("SharedDBConnection, can't find the key:" + dbConnectionName + " " + "so create a new one and share it.");
            }
            Class.forName(dbDriver);
            connection = DriverManager.getConnection(url, userName, password);
            this.sharedConnections.put(dbConnectionName, connection);
        } else if (connection.isClosed()) {
            if (DEBUG) {
                System.out.println("SharedDBConnection, find the key: " + dbConnectionName + " " + "But it is closed. So create a new one and share it.");
            }
            connection = DriverManager.getConnection(url, userName, password);
            this.sharedConnections.put(dbConnectionName, connection);
        } else if (DEBUG) {
            System.out.println("SharedDBConnection, find the key: " + dbConnectionName + " " + "it is OK.");
        }
        return connection;
    }

    public static Connection getDBConnection(String dbDriver, String url, String userName, String password, String dbConnectionName) throws ClassNotFoundException, SQLException {
        SharedDBConnection instanceLocal = SharedDBConnection.getInstance();
        Connection connection = instanceLocal.getConnection(dbDriver, url, userName, password, dbConnectionName);
        return connection;
    }

    public static void clear() {
        instance = null;
    }

    public static void setDebugMode(boolean debug) {
        DEBUG = debug;
    }
}

