/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.Date;
import routines.TalendDate;

public class FormatterUtils {
    public static String format_Date(Date date, String pattern) {
        if (date != null) {
            return TalendDate.formatDate(pattern, date);
        }
        return null;
    }

    public static String format_Date_Locale(Date date, String pattern, String locale) {
        if (date != null) {
            return TalendDate.formatDateLocale(pattern, date, locale);
        }
        return null;
    }

    public static String format_Number(String s, Character thousandsSeparator, Character decimalSeparator) {
        if (s == null) {
            return null;
        }
        String result = s;
        int decimalIndex = s.indexOf(".");
        if (decimalIndex == -1) {
            if (thousandsSeparator != null) {
                return FormatterUtils.formatNumber(result, thousandsSeparator.charValue());
            }
            return result;
        }
        result = thousandsSeparator != null ? FormatterUtils.formatNumber(s.substring(0, decimalIndex), thousandsSeparator.charValue()) : s.substring(0, decimalIndex);
        result = decimalSeparator != null ? String.valueOf(result) + s.substring(decimalIndex).replace('.', decimalSeparator.charValue()) : String.valueOf(result) + s.substring(decimalIndex);
        return result;
    }

    private static String formatNumber(String s, char thousandsSeparator) {
        StringBuilder sb = new StringBuilder(s);
        int index = sb.length();
        index -= 3;
        while (index > 0 && sb.charAt(index - 1) != '-') {
            sb.insert(index, thousandsSeparator);
            index -= 3;
        }
        return sb.toString();
    }

    public static String unformat_Number(String s, Character thousandsSeparator, Character decimalSeparator) {
        if (s == null) {
            return null;
        }
        String result = s;
        int decimalIndex = s.indexOf(decimalSeparator.charValue());
        if (decimalIndex == -1) {
            if (thousandsSeparator != null) {
                return FormatterUtils.unformatNumber(result, thousandsSeparator);
            }
            return result;
        }
        result = thousandsSeparator != null ? FormatterUtils.unformatNumber(s.substring(0, decimalIndex), thousandsSeparator) : s.substring(0, decimalIndex);
        result = decimalSeparator != null ? ("\\.".equals(decimalSeparator) ? String.valueOf(result) + s.substring(decimalIndex).replace(thousandsSeparator.charValue(), decimalSeparator.charValue()) : String.valueOf(result) + s.substring(decimalIndex).replace(decimalSeparator.charValue(), '.')) : String.valueOf(result) + s.substring(decimalIndex);
        return result;
    }

    private static String unformatNumber(String str, Character thousandsSeparator) {
        String[] s;
        StringBuilder returnString = new StringBuilder();
        String separator = thousandsSeparator.toString();
        if (".".equals(separator)) {
            separator = "\\.";
        }
        String[] stringArray = s = str.split(separator);
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            returnString.append(part);
            ++n2;
        }
        return returnString.toString();
    }

    public static String formatUnwithE(Object arg) {
        String doubleString = String.valueOf(arg);
        if (doubleString.indexOf("E") != -1) {
            String position = doubleString.charAt(doubleString.indexOf("E") + 1) != '-' ? doubleString.substring(doubleString.indexOf("E") + 1) : doubleString.substring(doubleString.indexOf("E") + 2);
            return String.format("%1." + position + "f", arg);
        }
        return doubleString;
    }
}

