/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleProvider {
    private static Map<String, Locale> cache;

    public static void main(String[] args) {
        System.out.println("FR => " + LocaleProvider.getLocale("FR"));
        System.out.println("fr => " + LocaleProvider.getLocale("fr"));
        System.out.println("tw => " + LocaleProvider.getLocale("tw"));
        System.out.println("TW => " + LocaleProvider.getLocale("TW"));
        System.out.println("zh => " + LocaleProvider.getLocale("zh"));
        System.out.println("ZH => " + LocaleProvider.getLocale("ZH"));
    }

    public static Locale getLocale(String languageOrCountyCode) {
        if (cache == null) {
            LocaleProvider.initCache();
        }
        Locale locale = null;
        if (languageOrCountyCode != null) {
            locale = cache.get(languageOrCountyCode.toLowerCase());
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    private static void initCache() {
        cache = new HashMap<String, Locale>();
        Locale[] availableLocales = Locale.getAvailableLocales();
        int i = 0;
        while (i < availableLocales.length) {
            Locale locale = availableLocales[i];
            String country = locale.getCountry();
            String language = locale.getLanguage();
            String key = null;
            if (country.length() > 0) {
                key = country;
            } else if (language.length() > 0) {
                key = language;
            }
            if (key != null) {
                cache.put(key.toLowerCase(), locale);
            }
            ++i;
        }
    }
}

