/*
 * Decompiled with CFR 0.152.
 */
package routines.system;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String[] split(String str, String separator) {
        return str.split(separator);
    }

    public static String deleteChar(String s, char delChar) {
        int len = s.length();
        char[] val = s.toCharArray();
        char[] buf = new char[len];
        int m = 0;
        int k = 0;
        while (k < len) {
            char c = val[k];
            if (c != delChar) {
                buf[m] = c;
                ++m;
            }
            ++k;
        }
        return new String(buf, 0, m);
    }

    public static String list(String[] stringArray) {
        return StringUtils.list(stringArray, null, null, null, null);
    }

    public static String list(String[] stringArray, String separator) {
        return StringUtils.list(stringArray, separator, null, null, null);
    }

    public static String list(String[] stringArray, String separator, String startEnclosure, String endEnclosure) {
        return StringUtils.list(stringArray, separator, startEnclosure, endEnclosure, null);
    }

    public static String list(String[] stringArray, String separator, String escaper) {
        return StringUtils.list(stringArray, separator, null, null, escaper);
    }

    public static String list(String[] stringArray, String separator, String startEnclosure, String endEnclosure, String escaper) {
        separator = separator == null ? "" : separator.trim();
        startEnclosure = startEnclosure == null ? "" : startEnclosure.trim();
        endEnclosure = endEnclosure == null ? "" : endEnclosure.trim();
        escaper = escaper == null ? "" : escaper.trim();
        StringBuilder result = new StringBuilder();
        result.append(startEnclosure);
        boolean flag = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray2[n2];
            item = item.trim();
            if (flag) {
                result.append(separator);
            } else {
                flag = true;
            }
            result.append(escaper);
            result.append(item);
            result.append(escaper);
            ++n2;
        }
        result.append(endEnclosure);
        return result.toString();
    }

    public static String replaceAll(String src, String regex, String replacement) {
        if (regex == null) {
            if (src == null) {
                return replacement;
            }
            return src;
        }
        if (src == null) {
            return null;
        }
        if (replacement == null) {
            if (src.matches(regex)) {
                return replacement;
            }
            return src;
        }
        return src.replaceAll(regex, replacement);
    }

    public static String replaceAllStrictly(String src, String search, String replacement, boolean entirelyMatch, boolean caseSensitive) {
        if (search == null) {
            if (src == null) {
                return replacement;
            }
            return src;
        }
        if (src == null) {
            return null;
        }
        if (replacement == null) {
            if (src.equals(search)) {
                return replacement;
            }
            return src;
        }
        if (entirelyMatch) {
            String upperSrc = caseSensitive ? src : src.toUpperCase();
            String upperSearch = caseSensitive ? search : search.toUpperCase();
            return upperSrc.equals(upperSearch) ? replacement : src;
        }
        int flag = caseSensitive ? 16 : 18;
        return Pattern.compile(search, flag).matcher(src).replaceAll(Matcher.quoteReplacement(replacement));
    }

    public static String escapeChar(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuffer sb = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\").append('n');
                    break;
                }
                case '\r': {
                    sb.append("\\").append('r');
                    break;
                }
                case '\t': {
                    sb.append("\\").append('t');
                    break;
                }
                case '\f': {
                    sb.append("\\").append('f');
                    break;
                }
                case '\b': {
                    sb.append("\\").append('b');
                    break;
                }
                case '\"': {
                    sb.append("\\").append('\"');
                    break;
                }
                case '\'': {
                    sb.append("\\").append('\'');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

