// *****************************************************************************
/**
 * MainFactoryMethod
 * @file MainFactoryMethod.java
 * @date 7 janv. 2012
 * @author brunot
 * 
 * ZZ3_JAVA-AV_TP - com.isima.zz3.advjava.tp0.factorymethod - Main.java
 * 
 * Design Pattern: Factory Method
 * <img src="doc-files/factorymethod.png">
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * TODOList : 
 * 	- ...
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * ChangeLog : 
 * 
 * CRT brunot 7 janv. 2012 Cration du fichier
 * 
 * MAJ ??? ??/??/???? ...
 * 
 */
// *****************************************************************************

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
// *****************************************************************************
package com.isima.zz3.advjava.tp1.factorymethod;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/** 
 * Design Pattern: Factory Method
 * <img src="doc-files/factorymethod.png">
 * 
 * @author brunot
 */
public class MainFactoryMethod {

	/**
	 * Design Pattern: Factory Method
	 * @param args
	 * 
	 * <ul>
	 * 	<li>Create the Factory 1</li>
	 * 	<li>Factory Operation</li>
	 * 	<li>Create the Factory 2</li>
	 * 	<li>Factory Operation</li>
	 * </ul>
	 * 
	 */
	public static void main(String[] args) {
		System.out.println("GOF Design Patterns: Factory Method");
		
		// Create the Factory 1
		ACreator creator = new Creator1();
		
		// Factory Operation
		creator.operation();
		
		// Create the Factory 2
		creator = new Creator2();
		
		// Factory Operation
		creator.operation();
		
	}

}


// *****************************************************************************
