// *****************************************************************************
/**
 * ASubject
 * @file ASubject.java
 * @date 7 janv. 2012
 * @author brunot
 * 
 * ZZ3_JAVA-AV_TP0 - com.isima.zz3.advjava.tp0.observer - ASubject.java
 * 
 * 
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * TODOList : 
 * 	- ...
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * ChangeLog : 
 * 
 * CRT brunot 7 janv. 2012 Cration du fichier
 * 
 * MAJ ??? ??/??/???? ...
 * 
 */
// *****************************************************************************

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
// *****************************************************************************
package com.isima.zz3.advjava.tp1.observer;

import java.util.Collection;
import java.util.Iterator;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/**
 * 
 * 
 * @author brunot
 */
public abstract class ASubject {

	/**
	 * @uml.property name="observers_"
	 * @uml.associationEnd readOnly="true" multiplicity="(0 -1)"
	 *                     aggregation="shared" inverse=
	 *                     "aSubject:com.isima.zz3.advjava.tp0.observer.AObserver"
	 */
	private Collection<AObserver> observers_ = new java.util.ArrayList<AObserver>();

	/**
	 * Getter of the property <tt>observers_</tt>
	 * 
	 * @return Returns the observers_.
	 * @uml.property name="observers_"
	 */
	public Collection<AObserver> getObservers() {
		return observers_;
	}

	/**
	 * Returns an iterator over the elements in this collection.
	 * 
	 * @return an <tt>Iterator</tt> over the elements in this collection
	 * @see java.util.Collection#iterator()
	 * @uml.property name="observers_"
	 */
	public Iterator<AObserver> observersIterator() {
		return observers_.iterator();
	}

	/**
	 * Returns <tt>true</tt> if this collection contains no elements.
	 * 
	 * @return <tt>true</tt> if this collection contains no elements
	 * @see java.util.Collection#isEmpty()
	 * @uml.property name="observers_"
	 */
	public boolean isObserversEmpty() {
		return observers_.isEmpty();
	}

	/**
	 * Returns <tt>true</tt> if this collection contains the specified element.
	 * 
	 * @param aObserver
	 *            whose presence in this collection is to be tested.
	 * @see java.util.Collection#contains(Object)
	 * @uml.property name="observers_"
	 */
	public boolean containsObservers(
			com.isima.zz3.advjava.tp1.observer.AObserver aObserver) {
		return observers_.contains(aObserver);
	}

	/**
	 * Returns <tt>true</tt> if this collection contains all of the elements in
	 * the specified collection.
	 * 
	 * @param observers
	 *            collection to be checked for containment in this collection.
	 * @see java.util.Collection#containsAll(Collection)
	 * @uml.property name="observers_"
	 */
	public boolean containsAllObservers(Collection observers) {
		return this.observers_.containsAll(observers);
	}

	/**
	 * Returns the number of elements in this collection.
	 * 
	 * @return the number of elements in this collection
	 * @see java.util.Collection#size()
	 * @uml.property name="observers_"
	 */
	public int observersSize() {
		return observers_.size();
	}

	/**
	 * Returns all elements of this collection in an array.
	 * 
	 * @return an array containing all of the elements in this collection
	 * @see java.util.Collection#toArray()
	 * @uml.property name="observers_"
	 */
	public com.isima.zz3.advjava.tp1.observer.AObserver[] observersToArray() {
		return observers_
				.toArray(new com.isima.zz3.advjava.tp1.observer.AObserver[observers_
						.size()]);
	}

	/**
	 * Returns an array containing all of the elements in this collection; the
	 * runtime type of the returned array is that of the specified array.
	 * 
	 * @param observers_
	 *            the array into which the elements of this collection are to be
	 *            stored.
	 * @return an array containing all of the elements in this collection
	 * @see java.util.Collection#toArray(Object[])
	 * @uml.property name="observers_"
	 */
	public com.isima.zz3.advjava.tp1.observer.AObserver[] observersToArray(
			com.isima.zz3.advjava.tp1.observer.AObserver[] observers_) {
		return this.observers_.toArray(observers_);
	}

	/**
	 * Attache un observateur au sujet.
	 */
	public void bind(AObserver observer) {
		if (this.observers_.add(observer))
			observer.setSubject(this);
	}

	/**
	 * Dtache un observateur du sujet.
	 */
	public void unbind(com.isima.zz3.advjava.tp1.observer.AObserver observer) {
		if (this.observers_.remove(observer))
			observer.setSubject(null);
	}

	/**
	 * Notification du sujet.
	 */
	public void notifyObservers() {
		for (Iterator<AObserver> it = this.observersIterator(); it.hasNext();)
			it.next().update();
	}

}

// *****************************************************************************
