// *****************************************************************************
/**
 * MainObserver
 * @file MainObserver.java
 * @date 7 janv. 2012
 * @author brunot
 * 
 * ZZ3_JAVA-AV_TP - com.isima.zz3.advjava.tp0.observer - Main.java
 * 
 * Design Pattern: Observer
 * <img src="doc-files/observer.png">
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * TODOList : 
 * 	- ...
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * ChangeLog : 
 * 
 * CRT brunot 7 janv. 2012 Cration du fichier
 * 
 * MAJ ??? ??/??/???? ...
 * 
 */
// *****************************************************************************

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
// *****************************************************************************
package com.isima.zz3.advjava.tp1.observer;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/**
 * Design Pattern: Observer
 * <img src="doc-files/observer.png">
 * 
 * @author brunot
 */
public class MainObserver {

	/**
	 * Design Pattern: Observer
	 * @param args
	 * 
	 * <ul>
	 * 	<li>Create the subject and the observer</li>
	 * 	<li>Bind the observer to the subject</li>
	 * 	<li>Print the status of the subject observer</li>
	 * 	<li>Change the status of the subject</li>
	 * 	<li>Print the status of the observer</li>
	 * </ul>
	 * 
	 */
	public static void main(String[] args) {
		System.out.println("GOF Design Patterns: Observer");
		
		// Create the subject and the observer
		Subject subject = new Subject();
		Observer observer = new Observer();
		
		// Bind the observer to the subject
		subject.bind(observer);
		
		// Print the status of the subject observer
		System.out.println(subject.getStatus());
		System.out.println(observer.getStatus());
		
		// Change the status of the subject
		subject.changeStatus();
		
		// Print the status of the observer
		System.out.println(subject.getStatus());
		System.out.println(observer.getStatus());
		
	}

}

// *****************************************************************************
