// *****************************************************************************
/**
 * Observer
 * @file Observer.java
 * @date 7 janv. 2012
 * @author brunot
 * 
 * ZZ3_JAVA-AV_TP0 - com.isima.zz3.advjava.tp0.observer - Observer.java
 * 
 * 
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * TODOList : 
 * 	- ...
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * ChangeLog : 
 * 
 * CRT brunot 7 janv. 2012 Cration du fichier
 * 
 * MAJ ??? ??/??/???? ...
 * 
 */
// *****************************************************************************

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
// *****************************************************************************
package com.isima.zz3.advjava.tp1.observer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/**
 * 
 * 
 * @author brunot
 */
public class Observer extends AObserver {

	/**
	 * Mis  jour
	 */
	public void update() {
		String status = subject_.getStatus();
		DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		Date currentDateTime = new Date();
        dateFormat.format(currentDateTime);

		this.status_ = subject_.toString() + " changed at " + dateFormat.format(currentDateTime) + ": " + status;
		
	}

	/**
	 * @uml.property name="subject_"
	 * @uml.associationEnd 
	 *                     inverse="observer:com.isima.zz3.advjava.tp0.observer.Subject"
	 */
	private Subject subject_;

	/**
	 * Getter of the property <tt>subject_</tt>
	 * 
	 * @return Returns the subject_.
	 * @uml.property name="subject_"
	 */
	public Subject getSubject() {
		return subject_;
	}

	/**
	 * Setter of the property <tt>subject_</tt>
	 * 
	 * @param subject
	 *            The subject_ to set.
	 * @uml.property name="subject_"
	 */
	public void setSubject(Subject subject) {
		this.subject_ = subject;
	}

	/**
	 * Etat de l'observeur.
	 * 
	 * @uml.property name="status_" readOnly="true"
	 */
	private String status_;

	/**
	 * Getter of the property <tt>status_</tt>
	 * 
	 * @return Returns the status_.
	 * @uml.property name="status_"
	 */
	public String getStatus() {
		return status_;
	}

	@Override
	public void setSubject(ASubject subject) {
		this.setSubject((Subject)(subject));
	}

}

// *****************************************************************************
