// *****************************************************************************
/**
 * MainStrategyFactoryMethod
 * @file MainStrategyFactoryMethod.java
 * @date 7 janv. 2012
 * @author brunot
 * 
 * ZZ3_JAVA-AV_TP - com.isima.zz3.advjava.tp0.strategyandfactorymethod - Main.java
 * 
 * Design Pattern: Strategy & Factory Method
 * <img src="doc-files/strategyandfactorymethod.png">
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * TODOList : 
 * 	- ...
 */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * ChangeLog : 
 * 
 * CRT brunot 7 janv. 2012 Cration du fichier
 * 
 * MAJ ??? ??/??/???? ...
 * 
 */
// *****************************************************************************

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
// *****************************************************************************
package com.isima.zz3.advjava.tp1.strategyandfactorymethod;

import com.isima.zz3.advjava.tp1.strategyandfactorymethod.ACreator;
import com.isima.zz3.advjava.tp1.strategyandfactorymethod.Creator1;
import com.isima.zz3.advjava.tp1.strategyandfactorymethod.Creator2;

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/**
 * Design Pattern: Strategy & Factory Method
 * <img src="doc-files/strategyandfactorymethod.png">
 * 
 * @author brunot
 */
public class MainStrategyFactoryMethod {

	/**
	 * Design Pattern: Strategy & Factory Method
	 * @param args
	 * 
	 * <ul>
	 * 	<li>Create the Factory 1</li>
	 * 	<li>Factory Operation</li>
	 * 	<li>Create the Factory 2</li>
	 * 	<li>Factory Operation</li>
	 * </ul>
	 * 
	 */
public static void main(String[] args) {
	System.out.println("GOF Design Patterns: Strategy + Factory Method");
	
	ACreator creator = new Creator1();
	creator.operation();
	
	creator = new Creator2();
	creator.operation();
}

}

// *****************************************************************************
